#include <cmath>
#include <iostream>
#include <limits>
#include <vector>

struct Point 
{
    int x;
    int y;
};

Point minDist(Point s, std::vector<Point> e)
{
    Point min;
    double mDist = std::numeric_limits<double>::infinity();

    for (Point p : e)
    {
        double dist = std::sqrt(std::pow(p.y - s.x, 2) + std::pow(p.x - s.y, 2));
        if (dist < mDist)
        {
            min = p;
            mDist = dist;
        }
    }

    return min;
}

int main()
{
    int w, h;
    std::cin >> w >> h;
    int bx, by;
    std::cin >> bx >> by;
    int ex, ey;
    std::cin >> ex >> ey;

    if (bx == ex && by == ey)
    {
        std::cout << 0 << std::endl;
        return 0;
    }

    bx += w;
    by += h;

    std::vector<Point> exits;

    for (int i = 0; i < 3; i++)
    {
        for (int j = 0; j < 3; j++)
        {
            Point p = { ey + (h * i), ex + (w * j) };
            exits.push_back(p);
        }
    }

    Point s = { bx, by };
    Point min = minDist(s, exits);

    int moves = std::abs(min.y - s.x) + std::abs(min.x - s.y);
    std::cout << moves << std::endl;

    return 0;
}